/*
 * Decompiled with CFR 0.152.
 */
package gtnhintergalactic.tile.multi.elevatormodules;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtnhintergalactic.gui.IG_UITextures;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public abstract class TileEntityModuleBase
extends TTMultiblockBase {
    protected static long EU_BUFFER_BASE_SIZE = 160008000L;
    protected final long euBufferSize;
    protected final int tTier;
    protected final int tModuleTier;
    protected final int tMinMotorTier;
    protected boolean isConnected = false;
    Parameters.Group.ParameterOut energyDisplay;
    private static final INameFunction<TileEntityModuleBase> ENERGY_DISPLAY_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.cfgo.0");
    private static final IStatusFunction<TileEntityModuleBase> ENERGY_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 1.0, (double)base.maxEUStore() / 2.0, (double)base.maxEUStore() * 2.0, (double)base.maxEUStore() * 2.0, new double[0]);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<TileEntityModuleBase> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"H", "H"}, {"~", "H"}, {"H", "H"}, {"H", "H"}, {"H", "H"}})).addElement('H', GTStructureUtility.ofHatchAdderOptional(TTMultiblockBase::addClassicToMachineList, 4096, 1, GregTechAPI.sBlockCasingsSE, 0)).build();

    protected TileEntityModuleBase(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7);
        this.useLongPower = true;
    }

    protected TileEntityModuleBase(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aID, aName, aNameRegional);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7) * (long)bufferSizeMultiplier;
        this.useLongPower = true;
    }

    protected TileEntityModuleBase(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7);
        this.useLongPower = true;
    }

    protected TileEntityModuleBase(String aName, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aName);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7) * (long)bufferSizeMultiplier;
        this.useLongPower = true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && this.isConnected) {
            super.onPostTick(aBaseMetaTileEntity, aTick);
            if (aTick % 400L == 0L) {
                this.fixAllIssues();
            }
            if (aTick % 20L == 0L) {
                this.energyDisplay.set(this.getEUVar());
            }
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (aBaseMetaTileEntity.getStoredEU() <= 0L && this.mMaxProgresstime > 0) {
                this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            }
        }
    }

    @Override
    public boolean drainEnergyInput(long EUtEffective, long Amperes) {
        long EUuse = EUtEffective * Amperes;
        if (EUuse == 0L) {
            return true;
        }
        if (EUuse < 0L) {
            EUuse = -EUuse;
        }
        if (EUuse <= this.getEUVar()) {
            this.setEUVar(this.getEUVar() - EUuse);
            return true;
        }
        return false;
    }

    @Override
    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    @Override
    public long maxEUStore() {
        return this.euBufferSize;
    }

    public long increaseStoredEU(long maximumIncrease) {
        if (this.getBaseMetaTileEntity() == null) {
            return 0L;
        }
        this.connect();
        long increasedEU = Math.min(this.getBaseMetaTileEntity().getEUCapacity() - this.getBaseMetaTileEntity().getStoredEU(), maximumIncrease);
        return this.getBaseMetaTileEntity().increaseStoredEnergyUnits(increasedEU, false) ? increasedEU : 0L;
    }

    public void connect() {
        this.isConnected = true;
    }

    public void disconnect() {
        this.isConnected = false;
    }

    @Override
    protected void chargeController_EM(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    public int getTier() {
        return this.tTier;
    }

    public int getNeededMotorTier() {
        return this.tMinMotorTier;
    }

    @Override
    public long getMaxInputVoltage() {
        return GTValues.V[this.tTier];
    }

    @Override
    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 0, 1, 0, stackSize, hintsOnly);
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.fixAllIssues();
        return this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 0, 1, 0);
    }

    @Override
    public boolean willExplodeInRain() {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(4096), new TTRenderedExtendedFacingTexture(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(4096)};
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)IG_UITextures.PICTURE_ELEVATOR_LOGO_DARK).setSize(18, 18).setPos(173, 74));
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0);
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("138", "Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.ready")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.noRecipe")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.recipe")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getBaseMetaTileEntity().isActive()));
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, false);
        this.energyDisplay = hatch_0.makeOutParameter(0, 0.0, ENERGY_DISPLAY_NAME, ENERGY_STATUS);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

